/*
 * Decompiled with CFR 0.152.
 */
package mods.flammpfeil.slashblade.event;

import mods.flammpfeil.slashblade.SlashBlade;
import mods.flammpfeil.slashblade.SlashBladeConfig;
import mods.flammpfeil.slashblade.data.builtin.SlashBladeBuiltInRegistry;
import mods.flammpfeil.slashblade.registry.slashblade.SlashBladeDefinition;
import net.minecraft.core.Registry;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntitySpawnEventHandler {
    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        Mob entity = event.getEntity();
        boolean isZombie = EntitySpawnEventHandler.isZombie((LivingEntity)entity);
        if (!isZombie) {
            return;
        }
        if (!entity.m_6844_(EquipmentSlot.MAINHAND).m_41619_()) {
            return;
        }
        RandomSource random = event.getLevel().m_213780_();
        float difficultyMultiplier = event.getDifficulty().m_19057_();
        Registry<SlashBladeDefinition> bladeRegistry = SlashBlade.getSlashBladeDefinitionRegistry(event.getEntity().m_9236_());
        if (!bladeRegistry.m_7804_(SlashBladeBuiltInRegistry.SABIGATANA.m_135782_())) {
            return;
        }
        float rngResult = random.m_188501_();
        if ((double)rngResult < (Double)SlashBladeConfig.BROKEN_SABIGATANA_SPAWN_CHANCE.get() * (double)difficultyMultiplier) {
            if ((double)rngResult < (Double)SlashBladeConfig.SABIGATANA_SPAWN_CHANCE.get() * (double)difficultyMultiplier) {
                entity.m_8061_(EquipmentSlot.MAINHAND, ((SlashBladeDefinition)bladeRegistry.m_7745_(SlashBladeBuiltInRegistry.SABIGATANA.m_135782_())).getBlade());
            } else {
                entity.m_8061_(EquipmentSlot.MAINHAND, ((SlashBladeDefinition)bladeRegistry.m_7745_(SlashBladeBuiltInRegistry.SABIGATANA_BROKEN.m_135782_())).getBlade());
            }
        }
    }

    private static boolean isZombie(LivingEntity entity) {
        return entity instanceof Zombie && !(entity instanceof Drowned) && !(entity instanceof ZombifiedPiglin);
    }
}

